// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package repo

import (
	"sync"
)

var (
	lockRepoMockGetArtifactList sync.RWMutex
)

// Ensure, that RepoMock does implement Repo.
// If this is not the case, regenerate this file with moq.
var _ Repo = &RepoMock{}

// RepoMock is a mock implementation of Repo.
//
//     func TestSomethingThatUsesRepo(t *testing.T) {
//
//         // make and configure a mocked Repo
//         mockedRepo := &RepoMock{
//             GetArtifactListFunc: func(pageNum int64, rows int64) (ArtifactList, error) {
// 	               panic("mock out the GetArtifactList method")
//             },
//         }
//
//         // use mockedRepo in code that requires Repo
//         // and then make assertions.
//
//     }
type RepoMock struct {
	// GetArtifactListFunc mocks the GetArtifactList method.
	GetArtifactListFunc func(pageNum int64, rows int64) (ArtifactList, error)

	// calls tracks calls to the methods.
	calls struct {
		// GetArtifactList holds details about calls to the GetArtifactList method.
		GetArtifactList []struct {
			// PageNum is the pageNum argument value.
			PageNum int64
			// Rows is the rows argument value.
			Rows int64
		}
	}
}

// GetArtifactList calls GetArtifactListFunc.
func (mock *RepoMock) GetArtifactList(pageNum int64, rows int64) (ArtifactList, error) {
	if mock.GetArtifactListFunc == nil {
		panic("RepoMock.GetArtifactListFunc: method is nil but Repo.GetArtifactList was just called")
	}
	callInfo := struct {
		PageNum int64
		Rows    int64
	}{
		PageNum: pageNum,
		Rows:    rows,
	}
	lockRepoMockGetArtifactList.Lock()
	mock.calls.GetArtifactList = append(mock.calls.GetArtifactList, callInfo)
	lockRepoMockGetArtifactList.Unlock()
	return mock.GetArtifactListFunc(pageNum, rows)
}

// GetArtifactListCalls gets all the calls that were made to GetArtifactList.
// Check the length with:
//     len(mockedRepo.GetArtifactListCalls())
func (mock *RepoMock) GetArtifactListCalls() []struct {
	PageNum int64
	Rows    int64
} {
	var calls []struct {
		PageNum int64
		Rows    int64
	}
	lockRepoMockGetArtifactList.RLock()
	calls = mock.calls.GetArtifactList
	lockRepoMockGetArtifactList.RUnlock()
	return calls
}
